/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.popupevents.handler;

import club.sk1er.popupevents.handler.AbstractChatHandler;
import club.sk1er.popupevents.handler.GeneralChatHandler;
import club.sk1er.popupevents.handler.impl.DuelRequestHandler;
import club.sk1er.popupevents.handler.impl.FriendRequestHandler;
import club.sk1er.popupevents.handler.impl.GuildInviteHandler;
import club.sk1er.popupevents.handler.impl.PartyInviteHandler;
import club.sk1er.popupevents.handler.impl.SkyblockTradeRequestHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PopupHandlers {
    private List<AbstractChatHandler> chatHandlers = new ArrayList<AbstractChatHandler>();
    private GeneralChatHandler generalChatHandler = new GeneralChatHandler(this.chatHandlers);

    public PopupHandlers() {
        this.register(this.generalChatHandler);
        this.registerChatHandler(new FriendRequestHandler());
        this.registerChatHandler(new PartyInviteHandler());
        this.registerChatHandler(new SkyblockTradeRequestHandler());
        this.registerChatHandler(new DuelRequestHandler());
        this.registerChatHandler(new GuildInviteHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit() {
        this.generalChatHandler.post();
    }

    private void registerChatHandler(AbstractChatHandler chatHandler) {
        this.register(chatHandler);
        this.chatHandlers.add(chatHandler);
    }

    private void register(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    public List<AbstractChatHandler> getChatHandlers() {
        return this.chatHandlers;
    }

    public GeneralChatHandler getGeneralChatHandler() {
        return this.generalChatHandler;
    }

    @SubscribeEvent
    public void tick(TickEvent event) {
        IntegratedServer server = FMLClientHandler.instance().getClient().func_71401_C();
        if (server == null) {
            return;
        }
        ICommandManager commandManager = server.func_71187_D();
        if (commandManager == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.unregister(PopupHandlers.class);
    }
}

